this.name        = "ups_slaves"; 
this.author      = "eric walch"; 
this.copyright   = " 2008 the Oolite team."; 
this.description = "Slaves missions of UPS Courier"; 
this.version     = "1.4.2"; 


this.startUp = function()
{
    if (oolite.compareVersion("1.71") > 0)
    {
        // Oolite version is older than 1.71.
        log("script."+this.name, "This UPS-Courier missions does not run under Oolite version " + oolite.versionString + " Slave missions are disabled.")
        delete this.missionScreenEnded
        delete this.shipExitedWitchspace
        delete this.shipDockedWithStation
        delete this.shipLaunchedFromStation
        delete this.missionChoiceWasReset
        delete this.playerEnteredNewGalaxy
    }
    this.mark = false
    this.cleanup=this.CLEANUP;
}

this.reset = function()
{
    this.cleanup=this.CLEANUP;
}

this.shipWillLaunchFromStation = function(station)
{
    this.cleanup();
}

/* this.tickle is activated at the same points as the legacy script is activated. So it could be on every status. (even EXITTING_WITCHSPACE) Currently this is a good way to set up conclictfree messages that wait on each other. When you do it on docking and you detect there is already an other message shown, you won't get an second change for displaying the message. Version 1.71 will have a "missionChoiceWasReset" event.
Note that besides the tickles that are fired every 10 seconds, there is one just after docking, were status == "STATUS_DOCKED" but guiScreen = "GUI_SCREEN_MAIN". During the further docked tickles, guiScreen depends on the screen you are looking at.
*/

this.DISABLE=function(name)
{
    if (!this.old) this.old={};
    if (!name || name=="") return;
    if (!this.old[name])
            this.old[name]=this[name];
    delete this[name];
}

this.ENABLE=function(name)
{
    if (!name || name==""||!this.old) return;
    this[name]=this.old[name];
}

this.CLEANUP = function()
{ //can't check missionVariables inside startUp or reset
    if (!missionVariables.ups_slaverescue) // missionVariables.ups_slaverescue is set by a scooped slavehunter.
    {
        //no need to run any of these!
        this.DISABLE("shipDockedWithStation");	
        this.DISABLE("shipLaunchedFromStation");
        this.DISABLE("shipExitedWitchspace");
        this.DISABLE("missionScreenEnded");
        this.DISABLE("missionChoiceWasReset");
        this.DISABLE("playerEnteredNewGalaxy");
    } 
    else
    {
        if (this.old)
        {
            this.ENABLE("shipDockedWithStation");	
            this.ENABLE("shipLaunchedFromStation");
            this.ENABLE("shipExitedWitchspace");
            this.ENABLE("missionScreenEnded");		
            this.ENABLE("missionChoiceWasReset");		
            this.ENABLE("playerEnteredNewGalaxy");		
            log("script.ups_slaves", "Re-enabling ups_slaves script.");
        }
    }
    this.cleanup=function(){}; // run just once per script startup/reset
}

this.shipDockedWithStation = function()
{
// missionVariables.ups_slaverescue is set to "YES" by a scripted pilot.
    if (missionVariables.ups_slaverescue == "YES" && player.docked)
    {
        this.ups_missionOffers()
    }
}

/*
Missionoffers are trigered by docking, by ending of a missionscreen and by clearing the choises. However there are situations were the display of a missionscreen has be skipped when an other script has asked for it by setting "missionVariables.offering". But when that script does not do a display, there will never come a trigger. Launching will also reset the offering variable therefor the timer will only run when docked. 
*/

/*
All the offers are generated with the function below. The function is called after docking, after ending a previous mission screen when the choices are sorted out and by the timer.
*/
this.longRangeChart = function()
{
    if(guiScreen == "GUI_SCREEN_LONG_RANGE_CHART")
    {
        if(this.mark) {mission.unmarkSystem(this.chartLocation); this.mark = false}
        else {mission.markSystem(this.chartLocation); this.mark = true}
    }
    else
    {
        this.missionChartTimer.stop()
        mission.unmarkSystem(this.chartLocation)
        this.mark = true // Keep this selected system.
        missionVariables.offering = null
        mission.choice = null
        if(player.docked) this.ups_missionOffers()
        //without being docked, "player.dockedStation.isMainStation" generates errors in the log.
    }
}

this.ups_missionOffers = function()
{
    if (guiScreen == "GUI_SCREEN_MISSION") return; // there will be a "missionScreenEnded" in future to react uppon.
    if (missionVariables.offering || (mission.choice && mission.choice != "")) return;
    if (player.dockedStation.isMainStation)
    {
        let ups_choices = ""
        if (missionVariables.ups_slaves == "SLAVE" && !mission.choice)
        {
                if (oolite.compareVersion("1.72") > 0) ups_choices = "ups_slave_accepted_yesnolook"
                else ups_choices = "ups_slave_accepted_yesno" // untill I can proper show the galactic map
                mission.runMissionScreen("ups_slave_homeland", "UPS.png", ups_choices)
                missionVariables.offering ="HOMELANDS"
        }
        if (missionVariables.ups_slplanet == system.ID && missionVariables.ups_slaves == "HOMELAND")
        {
                missionVariables.ups_slaves = "NOT_NOW"
                mission.unmarkSystem(missionVariables.ups_slplanet)
                mission.runMissionScreen("ups_slave_homeland2", "UPS.png")
                mission.setInstructionsKey() 
                player.awardCargo("Gem-Stones", 15) 
                missionVariables.ups_slcount++
                this.increaseReputation()
        }
        if(missionVariables.ups_slaves == "RESCUEOFFER" && system.government > 3 && system.economy < 3)
        {
                if (oolite.compareVersion("1.72") > 0) ups_choices = "ups_slave_accepted2_yesnolook"
                else ups_choices = "ups_slave_accepted2_yesno" // untill I can proper show the galactic map
                mission.runMissionScreen("ups_slave_rescueoffer", "UPS.png", ups_choices)
                missionVariables.offering ="RESCUE"
        }
        if(missionVariables.ups_slaves == "RESCUE" && system.ID == missionVariables.ups_sl2planet && missionVariables.ups_convoy == "KILLED")
        {
                if(missionVariables.ups_sl2count > 10)
                {
                    mission.runMissionScreen("ups_slave_rescue10")
                    player.awardCargo("Gem-Stones", 50)
                } 
                else
                {
                    if(missionVariables.ups_sl2count > 0) mission.runMissionScreen("ups_slave_rescue")
                    else mission.runMissionScreen("ups_slave_rescue0")
                }
                missionVariables.ups_sl2count = null 
                mission.unmarkSystem(missionVariables.ups_sl2planet)
                missionVariables.ups_sl2planet = null
                missionVariables.ups_sl2planetname = null
                missionVariables.ups_convoy = null
                missionVariables.ups_convoy_attack = null
                mission.setInstructionsKey()
                missionVariables.ups_slcount += 3
                missionVariables.ups_slaves = "NOT_NOW"
        }
        if (missionVariables.ups_slaves == "FINALOFFER" && system.government > 2 && !mission.choice)
        {
                mission.runMissionScreen("ups_slave_final", null, "ups_slave_accepted_yesno")
                missionVariables.offering ="FINAL"
        }
        if (missionVariables.ups_slaves == "FINAL" && missionVariables.ups_slplanet == system.ID)
        {
            mission.runMissionScreen("ups_slave_groundbattle", null, null, "ups_slave_satellite")
            missionVariables.ups_slaves = "GROUNDBATTLE"
            mission.setInstructionsKey("ups_slave_groundbattle_small") 
            missionVariables.ups_slavesrescued = 5
        }
        if (missionVariables.ups_slaves == "DEBRIEFING" && missionVariables.ups_slplanet == system.ID)
        {
            missionVariables.ups_slaves = "NOT_NOW"
            mission.setInstructionsKey() 
            if(missionVariables.ups_slavesrescued == "5")
            {
                mission.runMissionScreen("ups_slave_debriefing")
                player.credits += 6000
            }
            else
            {
                if(missionVariables.ups_slavesrescued == "0")
                {
                    mission.runMissionScreen("ups_slave_debriefing2")
                }
                else
                {
                    mission.runMissionScreen("ups_slave_debriefing1")
                    player.credits += 4000
                }
            }
            mission.setInstructionsKey() 
            this.resetSlaves()
            return;
        }
    }
    if (player.dockedStation.shipDescription == "Ground Radar")
    {
        if (missionVariables.ups_slaves == "DEBRIEFING" || missionVariables.ups_slaves == "GROUNDBATTLE")
        {
            mission.runMissionScreen("ups_slave_trapped")
            missionVariables.ups_slaves = "FAILED", 
            this.resetSlaves()
        }
    }
}

this.ups_choiceEvaluation = function()
{
    if (missionVariables.offering == "HOMELANDS")
    {
        this.mark = false
        if (mission.choice == "YESSlave")
        {
            mission.markSystem(missionVariables.ups_slplanet) 
            mission.setInstructionsKey("ups_slave_small") 
            missionVariables.ups_slaves = "HOMELAND" 
            missionVariables.offering = null
            mission.choice = null
        }
        else
        {
            if(mission.choice == "LOOKSlave")
            {
                player.call("setGuiToLongRangeChartScreen")
                this.chartLocation = missionVariables.ups_slplanet
                if(this.missionChartTimer) this.missionChartTimer.start()
                else this.missionChartTimer = new Timer(this, this.longRangeChart, 0.5, 0.5)
            }
            else
            {
                if (mission.choice == "NOSlave")
                { 
                    missionVariables.ups_slaves = "NOT_NOW" 
                    missionVariables.offering = null
                    mission.choice = null
                    if(Math.random()<0.5) this.decreaseReputation()
                } else {mission.runMissionScreen("ups_warning2", "UPS.png"); missionVariables.offering = null}
            }
        }
    }
    if (missionVariables.offering == "RESCUE")
    {
        if (mission.choice == "YESSlave")
        {
            mission.markSystem(missionVariables.ups_sl2planet) 
            mission.setInstructionsKey("ups_slave_small3") 
            missionVariables.ups_slaves = "RESCUE" 
            missionVariables.offering = null
            missionVariables.ups_sl2count = "0"
            missionVariables.ups_convoy = null 
            missionVariables.ups_convoy_attack = null
            mission.choice = null
        }
        else
        {
            if(mission.choice == "LOOKSlave")
            {
                player.call("setGuiToLongRangeChartScreen")
                this.chartLocation = missionVariables.ups_sl2planet
                if(this.missionChartTimer) this.missionChartTimer.start()
                else this.missionChartTimer = new Timer(this, this.longRangeChart, 0.5, 0.5)
            }
            else
            {
                if (mission.choice == "NOSlave")
                { 
                    missionVariables.ups_slaves = "NOT_NOW" 
                    missionVariables.offering = null
                    mission.choice = null
                } else {mission.runMissionScreen("ups_warning2", "UPS.png"); missionVariables.offering = null}
            }
        }
    }
    if (missionVariables.offering == "FINAL")
    {
        if (mission.choice == "YESSlave")
        {
            mission.markSystem(missionVariables.ups_slplanet) 
            mission.setInstructionsKey("ups_slave_small2") 
            missionVariables.ups_slaves = "FINAL" 
            missionVariables.offering = null
            mission.choice = null
        }
        else
        {
            if (mission.choice == "NOSlave")
            { 
                missionVariables.ups_slaves = "NOT_NOW" 
                missionVariables.offering = null
                mission.choice = null
            } else {mission.runMissionScreen("ups_warning2", "UPS.png"); missionVariables.offering = null}
        }
    }
}

this.missionScreenEnded = function()
{
    if(!player.docked) return;
    if (missionVariables.ups_slaverescue == "YES") 
    {
        if(mission.choice) this.ups_choiceEvaluation()
        this.ups_missionOffers()
    }
}

this.missionChoiceWasReset = function() // available in 1.71
{
    if(!player.docked) return;
    if (missionVariables.ups_slaverescue == "YES") 
    {
        this.ups_missionOffers()
    }
}


/* Defining a function with: "function = setUpShips_ups_slaves()" will lead to a function that is globally within Oolite. Meaning it is also seen by other scripts and therefor should have unique names.  Function defined  by "this.setUpShips_ups_slaves = function()" are only local to the script and will not give name conflicts with other OXP's. Therefor the method below is preferable.*/
this.setUpShips_ups_slaves = function()
{
    if(missionVariables.ups_slaves == "GROUNDBATTLE")
    {
        if(system.ID == missionVariables.ups_slplanet && system.countShipsWithRole("ups_slave_satellite") == 0)
        {
            system.legacy_addShipsAtPrecisely("ups_slave_satellite", 1, "pwp", 0, 0, 1.01) 
            system.legacy_addShipsAtPrecisely("ups_slave_satellite", 1, "pwp", 0, 0.05, 1.01) 
            system.legacy_addShipsAtPrecisely("ups_slave_satellite", 1, "pwp", 0.05, 0, 1.01) 
            system.legacy_addShipsAtPrecisely("ups_slave_satellite", 1, "pwp", 0.05, 0.05, 1.01) 
            missionVariables.ups_satellitecount = "4"
        }
    }
    if(missionVariables.ups_slaves == "RESCUE")
    {
        if(system.ID == missionVariables.ups_sl2planet && system.countShipsWithRole("ups-convoy-l") == 0 && !missionVariables.ups_convoy && !missionVariables.ups_convoy_attack)
        {
            system.legacy_addSystemShips("ups-convoy-l", 1, 0.5) 
        }
    }
}

this.shipExitedWitchspace = function()
{
  if(system.isInterstellarSpace) return;
  if (missionVariables.ups_slaverescue == "YES")
  {
    this.setUpShips_ups_slaves()
    if (!missionVariables.ups_slaves)
    { // selection of a tyarget system for all slave missions. And make sure you don't select a Nova system.
        if(system.government == 2 && system.economy > 5 && !system.goneNova)
        {
            missionVariables.ups_slaves = "NO" 
            missionVariables.ups_slplanet = system.ID 
            missionVariables.ups_slplanetname = expandDescription("[%H]") 
            missionVariables.ups_slcount = "0"
        }
    }
    if (missionVariables.ups_slaves == "NOT_NOW" && Math.random() < 0.1){missionVariables.ups_slaves = "NO"}
    if(missionVariables.ups_slaves == "NO")
    {
        if (missionVariables.ups_slaves == "NO" && missionVariables.ups_slcount > 5 && Math.random() > 0.9 && system.government > 2)
        {
            missionVariables.ups_slaves = "FINALOFFER"
        }
        if (missionVariables.ups_slaves == "NO" && !system.isInterstellarSpace && Math.random() > 0.75 && system.economy < 3)
        {
            let position = Math.random()*0.8+0.1; system.legacy_addSystemShips("ups-slavecobra", 1, position) 
        }
        if (missionVariables.ups_slaves == "NO" && missionVariables.ups_slcount > 1 && Math.random() > 0.9 && system.government == 2 && !system.goneNova)
        {
            missionVariables.ups_slaves = "RESCUEOFFER"
            missionVariables.ups_sl2planet = system.ID
            missionVariables.ups_sl2planetname = expandDescription("[%H]") 
        }
    }
  }
}

this.resetSlaves = function()
{
    mission.unmarkSystem(missionVariables.ups_slplanet)
    mission.setInstructionsKey() 
    if (missionVariables.ups_sl2count) mission.unmarkSystem(missionVariables.ups_sl2planet)
    missionVariables.ups_slcount = null
    missionVariables.ups_slavesrescue = null
    missionVariables.ups_slaves = null
    missionVariables.ups_slavename = null
    missionVariables.ups_slplanet = null
    missionVariables.ups_slplanetname = null
    missionVariables.ups_slavesrescued = null
    missionVariables.ups_sl2planet = null
    missionVariables.ups_sl2planetname = null
}

this.playerEnteredNewGalaxy = function()
{
   if (missionVariables.ups_slaves) this.resetSlaves()
}

this.shipLaunchedFromStation = function()
{
  if (missionVariables.ups_slaverescue == "YES")
  {
    this.setUpShips_ups_slaves()
  }
}

// temp fix for 1.71/1.72 compatibility.
this.increaseReputation = function()
{
        if (oolite.compareVersion("1.72") > 0) player.call("increasePassengerReputation")
        else player.increasePassengerReputation()
}

this.decreaseReputation = function()
{
        if (oolite.compareVersion("1.72") > 0) player.call("decreasePassengerReputation")
        else player.decreasePassengerReputation()
}
// 1.72 will have player.contractReputation and player.passengerReputation properties. 